/*------------------------------------------------------------------------------*
 * File Name: ComplexNumbersEx.c												*
 * Creation: GJL 3/28/2005														*
 * Purpose: OriginC Source C file containing a complex numbers example.			*
 * Copyright (c) OriginLab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
void ComplexNumbersEx()
{
		complex cc(4.5, -7.8);
		out_complex("\nComplex = ", cc);
		out_double("Real part = ", Re(cc));
		out_double("Imaginary part = ", Im(cc));
		printf("Phase = %g\tAmplitude = %g\n", cc.GetPhase(), cc.GetAmplitude());
		cc  = cc.Conjugate();
		out_complex("\nConjugate = ", cc);
		out_double("Real part = ", Re(cc));
		out_double("Imaginary part = ", Im(cc));
		printf("Phase = %g\tAmplitude = %g\n", cc.GetPhase(), cc.GetAmplitude());
}
		
		
		